/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class HashUtil {
    private HashUtil() {
    }

    public static String getFileHash(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        try (FileInputStream inputStream = new FileInputStream(file);){
            int total;
            byte[] buffer = new byte[1024];
            while ((total = ((InputStream)inputStream).read(buffer)) != -1) {
                digest.update(buffer, 0, total);
            }
        }
        return HashUtil.getHash(digest);
    }

    public static String getHash(MessageDigest digest) {
        StringBuilder result = new StringBuilder();
        for (byte b : digest.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

